/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.block.CopperButtonBlock;
import com.faboslav.friendsandfoes.block.ExposedCopperButtonBlock;
import com.faboslav.friendsandfoes.block.OxidizableButtonBlock;
import com.faboslav.friendsandfoes.block.WeatheredCopperButtonBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ButtonBlock.class})
public class AbstractButtonBlockMixin {
    @Inject(method={"getPressTicks"}, at={@At(value="HEAD")}, cancellable=true)
    public void getCopperPressTicks(CallbackInfoReturnable<Integer> callbackInfo) {
        AbstractButtonBlockMixin buttonBlock = this;
        if (buttonBlock instanceof CopperButtonBlock) {
            int pressTicks = 10;
            if (buttonBlock instanceof OxidizableButtonBlock) {
                OxidizableButtonBlock oxidizableButtonBlock = (OxidizableButtonBlock)((Object)buttonBlock);
                WeatheringCopper.WeatherState OxidationLevel = oxidizableButtonBlock.getDegradationLevel();
                if (OxidationLevel == WeatheringCopper.WeatherState.EXPOSED) {
                    pressTicks = 7;
                } else if (OxidationLevel == WeatheringCopper.WeatherState.WEATHERED) {
                    pressTicks = 4;
                } else if (OxidationLevel == WeatheringCopper.WeatherState.OXIDIZED) {
                    pressTicks = 1;
                }
            } else if (buttonBlock instanceof ExposedCopperButtonBlock) {
                pressTicks = 7;
            } else if (buttonBlock instanceof WeatheredCopperButtonBlock) {
                pressTicks = 4;
            } else if (buttonBlock instanceof OxidizableButtonBlock) {
                pressTicks = 1;
            }
            callbackInfo.setReturnValue((Object)pressTicks);
        }
    }
}

